﻿:Namespace partScan
    
⍝ Namespace containing utilities to manipulate lists partitioned with a boolean vector

⍝ Some of these use ⎕IO implicitely because they are ⎕IO independent.
⍝ Because this namespace's ⎕IO is probably not the same as the calling environment
⍝ we use a cover program to return the caller's ⎕IO:

    ∇ io←∆IO
      io←(⎕IO⊃1⌽⎕RSI).⎕IO
    ∇
    
    ∇ result←mask maskParts sections
    ⍝ Masks parts according to boolean 'mask'.
    ⍝ Each 1 in <sections> designates the beginning of a part.
    ⍝ e.g.  1 0 1 0 maskparts 1 0 0 1 0 1 0 1 0 ←→ 1 1 1 0 0 1 1 0 0.  ⎕io-independent.
      result←≠\sections\mask≠¯1↓0,mask
    ∇
    
    ∇ z←a p1Rot b
    ⍝ Partitioned 1-ROTate
      z←b[⍋a++\a]
    ∇
    
    ∇ z←a pAndr b
    ⍝ Partitioned AND Reduction
      z←(a/1⌽a←(a≥b)/a)∧a/b
    ∇
    ∇ z←a pAnds b
    ⍝ Partitioned AND Scan
      z←~≠\a\z≠¯1↓1,z←(a←a≥b)/b
    ∇
    
    ∇ z←a pComp b
    ⍝ Returns compression vector to perform a partitioned compress as designated by <a>
    ⍝   eg,     1 0 1 1 0 0 0 0 1 1 0 1  pcomp  0 1 1 0 1 0
    ⍝       ←→  0 0 1 1 1 1 1 1 0 1 1 0
      z←(+\a)∊(~∆IO)+b/⍳⍴b
    ∇
    
    ∇ z←a pEqr b
    ⍝ Partitioned EQual Reduction
      z←z=1,¯1↓z←(1⌽a)/=\b
    ∇
    
    ∇ z←a pEqs b
    ⍝ Partitioned EQual Scan
      z←=\b≠a\z≠¯1↓1,z←a/=\¯1↓1,b
    ∇
    
    ∇ z←a pGradedown b
    ⍝ Partitioned GRADEDOWN
      z←1/(⍴b)⍴(⍋(+\a\2×⌈/|0,,b)-,b)-⌈\a\(a/⍳⍴a)-∆IO
    ∇
    
    ∇ z←a pGradeup b
    ⍝ Partitioned GRADEUP
      z←(⍋(+\a\2×⌈/|0,,b)+,b)-⌈\a\(a/⍳⍴a)-∆IO
    ∇
    
    ∇ z←pLengths a
    ⍝ returns the lengths of each partition as designated by <a>
      z←(1↓z,⎕IO+⍴a)-z←a/⍳⍴a
    ∇
    
    ∇ z←a pLer b;x
    ⍝ Partitioned Less than or Equal Reduction
      z←(x/b)≥(z/1⌽z←(a≥z)/a)∧a/z←b∨x←1⌽a
    ∇
    
    ∇ z←a pLes b
    ⍝ partitioned Less-than or Equal Scan
      z←(b\z<¯1↓1,z←(b←b≤a)/b)<b≥a
    ∇
    
    ∇ z←a pLtr b;x
    ⍝ Partitioned Less Than Reduction
      z←(x/b)<(z/1⌽z←(a≥z)/a)∧a/z←(b←~b)∨x←1⌽a
    ∇
    
    ∇ z←a pLts b
    ⍝ Partitioned Less-Than Scan
      z←(a∨b)/b ⋄ z←(a∧b)∨(a∨b)\z>¯1↓0,z
    ∇
    
    ∇ z←a pMaxr b
    ⍝ Partitioned MAX Reduce
      z←(1⌽a)/(⌈\b+z)-z←+\a\⌈/b
    ∇
    
    ∇ z←a pMaxs b
    ⍝ Partitioned MAX Scan
      z←(⌈\b+z)-z←+\a\⌈/b
    ∇
    
    ∇ z←a pMinr b
    ⍝ Partitioned MIN Reduce
      z←(1⌽a)/(⌊\b-z)+z←+\a\⌈/b
    ∇
    
    ∇ z←a pMins b
    ⍝ Partitioned MIN Scan
      z←(⌊\b-z)+z←+\a\⌈/b
    ∇
    
    ∇ z←a pn1Rot b
    ⍝ Partitioned ¯1-ROTate
      z←b[⍋(+\a)-1⌽a]
    ∇
    
    ∇ z←a pUer b
    ⍝ Partitioned UnEqual Reduction
      z←z≠0,¯1↓z←(1⌽a)/≠\b
    ∇
    
    ∇ z←a pUes b
    ⍝ Partitioned UnEqual Scan
      z←≠\b≠a\z≠¯1↓0,z←a/≠\¯1↓0,b
    ∇
    
    ∇ z←a pnRot b;i;j
    ⍝ Returns the permutation vector to perform a partitioned n-rotate on
    ⍝ a vector whose partitions are designated by <a>.
      i←(1⌽a)/⍳⍴a ⋄ j←+\a
      i←i-¯1↓0,i ⋄ z←⍋j+(i|b)[j]≥+\1-a\¯1↓0,i
    ∇
    
    ∇ z←a pOrr b
    ⍝ Partitioned OR Reduction
      z←((¯1↓⍴b),+/a)⍴(z/1⌽z←(a∨b)/a)≤a/b
    ∇
    
    ∇ z←a pOrs b;x
    ⍝ Partitioned OR Scan
      z←≠\z\x≠¯1↓0,x←(z←a∨b)/b
    ∇
    
    ∇ z←a pPlr b
    ⍝ Partitioned PLus Reduction
      z←b-¯1↓0,b←(1⌽a)/+\b
    ∇
    
    ∇ z←a pPls b
    ⍝ Partitioned PLus Scan
      z←+\b-a\z-¯1↓0,z←a/+\¯1↓0,b
    ∇
    
    ∇ z←a pRev b
    ⍝ Partitioned REVerse
      z←b[⌽⍒+\a]
    ∇
    
    ∇ z←a pReverse b
    ⍝ Reverses the order of the partitions in 'b' as designated by 'a'
      z←b[⍒+\a]
    ∇
    
    ∇ z←a pSortdown b
    ⍝ Sorts the partitions in 'b' as designated by 'a'
      z←⍒b
      z←b[z[⍋(+\a)[z]]]
    ∇
    
    ∇ z←a pSortup b
    ⍝ Sorts the partitions in 'b' as designated by 'a'
      z←⍋b
      z←b[z[⍋(+\a)[z]]]
    ∇
    
:EndNamespace  ⍝ partScan  $Revision: 990 $ 