﻿:Class Clock
⍝ Covers system clock; no instances   V1.01

:Using System

    ⎕io←1

    :Field Private Shared _offset←0
    :Field Private Shared _stopped←0
    :Field Private Shared _ts←⎕TS

    DateToIDN←{+2 ⎕NQ'.' 'DateToIDN' ⍵}
    IDNToDate←{+2 ⎕NQ'.' 'IDNToDate' ⍵}

    ∇ Stop ⍝ freeze the clock
      :Access Public Shared
      (_stopped _ts)←1 ⎕TS
    ∇

    ∇ Resume ⍝ thaw the clock
      :Access Public Shared
      _stopped←0
    ∇

    ∇ Correct ⍝ synchronise to host
      :Access Public
      _offset←0
    ∇

    :Property Simple IDN
    :Access Public Shared
        ∇ z←get
          z←DateToIDN TS
        ∇
    :EndProperty

    :Property Simple TS
    :Access Public Shared
        ∇ z←get;ts
          ts←(_stopped+1)⊃⎕TS _ts
          :If 0=_offset
              z←ts
          :Else
              z←IDNToDate _offset+DateToIDN ts
          :EndIf
        ∇
        ∇ set arg
          (_stopped _ts)←1 arg.NewValue
          _offset←-/DateToIDN¨_ts ⎕TS
        ∇
    :EndProperty

    ∇ z←ToString ⍝ formatted with .Net localisation
      :Access Public Shared
      z←(DateTime.New TS).ToString ⍬
    ∇

:EndClass ⍝ Clock ⍝ Clock  $Revision: 1472 $