﻿:Class  Person
   ⍝ Copyright 2006 Lambent Technology
    
    :Include Tools   
   ⍝∇:require =/Tools
    
   ⍝ INI file for personal names in application root
    
    tmp←⎕se.SALT.Load 'tools/data/names -noname -nolink'
    
    :Field Private Shared ReadOnly BOYS←up¨tmp.Boys
    :Field Private Shared ReadOnly GIRLS←up¨tmp.Girls
    :Field Private Shared ReadOnly COMMON←BOYS∩GIRLS
    ⎕EX 'tmp'
    
    :Field Private Shared ReadOnly CRLF←⎕TC[3 2]
    :Field Private Shared ReadOnly PRONOUNS←('he' 'she')('him' 'her')('his' 'her')('his' 'hers')
    :Field Private Shared ReadOnly TITLES←'DR' 'MISS' 'MR' 'MRS' 'MS' 'SIR'
    
    ∆←''
    :Field Public PersonId←''
    ∆,←⊂'PersonId' 'num'
    :Field Public FamilyName←''
    ∆,←⊂'FamilyName' 'str'
    :Field Public Sex←''
    ∆,←⊂'Sex' 'str'
    :Field Public Title←''
    ∆,←⊂'Title' 'str'
    :Field Public BirthDate←⍬
    ∆,←⊂'BirthDate' 'dat'
    
    :Property Simple ForeNames
    :Access Public
        ∇ r←get
        ⍝ flatten a list of strings, using . to separate initials
          r←1↓{⍺←'' ⋄ 0=⍴⍵:⍺ ⋄ (⍺,('.'=¯1↑⍺){(' '/⍨~⍺∧i),⍵,'.'/⍨i←1=⍴,⍵}⊃⍵)∇ 1↓⍵}_foreNames
        ∇
        ∇ set args
          _foreNames←{×⍴⍵:,⊃,/forenameOrInitial¨⍵ ⋄ ⍵},wordsFrom args.NewValue
        ∇
    :EndProperty
    :Field Private Instance _foreNames←''
    ∆,←⊂'ForeNames' 'str'
    
    :Property Simple FullName
    :Access Public
        ∇ r←get
          r←ForeNames{0∊⊃∘⍴¨⍺ ⍵:⍺,⍵ ⋄ ⍺,' ',⍵}FamilyName
        ∇
        ∇ set args
          Title _foreNames FamilyName←interpret args.NewValue
          Sex←⊃Sex,guessSex Title _foreNames
        ∇
    :EndProperty
    
    :Field Private Shared ReadOnly SerialMap←↓⍉↑{(1⊃⍵)(dn 1⊃⍵)(2⊃⍵)}¨∆
    
⍝ CONSTRUCTORS..................................................................
    
    ∇ New0
      :Implements Constructor
      :Access Public
      initialise
    ∇
    ∇ New1 string
      :Implements Constructor
      :Access Public
      :If '<'=⊃string
          import xmlParse string
      :Else
          Title _foreNames FamilyName←interpret string
          Sex←guessSex Title _foreNames
      :EndIf
      initialise
    ∇
    ∇ import pairs;flds;nms;msk;tgts;vls
      flds←'FamilyName' 'ForeNames' 'Sex'
      (nms vls)←↓⍉↑pairs
      tgts←(up¨flds)⍳up¨nms
      msk←tgts≤⍴flds
      flds[msk/tgts]{⍎⍺,'←⍵'}¨msk/vls
    ∇
    ∇ New2(string sex)
      :Implements Constructor
      :Access Public
      Title _foreNames FamilyName←interpret string
      Sex←sex∩'MF'
      initialise
    ∇
    ∇ New3(string sex date)
      :Implements Constructor
      :Access Public
      New2 string sex
      BirthDate←date
      initialise
    ∇
    ∇ initialise
      PersonId←#.IdRegister.NextId'Person'
    ∇
    
⍝                   OTHER PUBLIC METHODS
    
    ∇ years←AgeAt date
      :Access Public
      :If BirthDate≢years←⍬
          years←{|-/(⊃¨⍵),>/100⊥¨1↓¨⍵}BirthDate date
      :EndIf
    ∇
    
    ∇ z←FormOfAddress form;frml;semi;⎕ML
      :Access Public Instance
     
      ⎕ML←1 ⍝ required for ∊ below
     
      frml←(1+⊃'MF'⍳Sex)⊃'Sir or Madam' 'Sir' 'Madam'
      semi←Title{×⍴⍺:⍺,' ',⍵ ⋄ frml}FamilyName
     
      :Select up form
      :Case 'ENVELOPE'
          z←' 'join(Title)(∊(,∘'.')∘⊃¨_foreNames)(FamilyName)
      :Case 'FORMAL'
          z←frml
      :Case 'FULL'
          z←FullName
      :Case 'INFORMAL'
          z←(⊃_foreNames){1<⍴⍺:⍺ ⋄ ⍵}semi
      :Case 'SEMIFORMAL'
          z←semi
      :Case 'TITLE'
          z←Title
      :Else
          showArgs'Envelope' 'Formal' 'Full' 'Informal' 'Semiformal' 'Title'
      :EndSelect
    ∇
    
    ∇ (sal val)←HelloGoodbye form;args;allobye;frml;semi
      :Access Public Instance
     
      allobye←'Dear ' 'Yours '∘(,¨)
      frml←(('MF'⍳⊃Sex)⊃'Sir' 'Madam' 'Sir or Madam')('faithfully')
      semi←Title{×⍴⍺:(⍺,' ',FamilyName)('sincerely') ⋄ ⍵}frml
     
      :Select up form
      :Case 'FORMAL'
          sal val←allobye frml
      :Case 'INFORMAL'
          sal val←allobye semi{1<⍴1⊃⍵:⍵ ⋄ ⍺}(1⊃_foreNames)('truly')
      :Case 'SEMIFORMAL'
          sal val←allobye semi
      :Else
          showArgs'Formal' 'Informal' 'Semiformal'
      :EndSelect
    ∇
    
    ∇ z←PossibleTitles
      :Access Public Instance
      z←('MF'⍳⊃Sex)⊃'Mr' 'Dr'{⍺ ⍵,⊂⍺∪⍵}'Ms' 'Miss' 'Mrs' 'Dr'
    ∇
    
    ∇ strg←Pronoun form;key;tris
      :Access Public Instance
     
      key←⊃∘(,/)¨PRONOUNS
      tris←{⍵,⊂' or 'join ⍵}¨PRONOUNS,⊂'' ''
      :If form⊂rc∊key
          strg←('MF'⍳1↑Sex∩'MF')⊃(key⍳⊂form)⊃tris
      :Else
          showArgs key
      :EndIf
    ∇
    
    ∇ z←XML;props
      :Access Public Instance
      props←'BirthDate' 'FamilyName' 'ForeNames' 'Sex' 'Title'
      z←props{'xml:Person'tag⊃,/⍺(dn rc tag)¨⍵}⍕∘⍎¨props
    ∇
    
⍝                   TRIGGER FNS
    
    ∇ allTriggers args;dflt;list
      :Implements Trigger Sex
     
      :If 1 0≡×⊃∘⍴∘,¨Sex Title ⍝ Sex defined but not Title
          Title←'Mr' 'Ms' ''⊃⍨'MF'⍳Sex
      :Else ⍝ validate title
          list←PossibleTitles
          dflt←⊃list
          Title←⊃Title dflt∩list
      :EndIf
    ∇
    
⍝                   PRIVATE METHODS
    
    ∇ showArgs args
      ⎕←'Arguments: ',' 'join''''{⍺,⍵,⍺}¨args
    ∇
    ∇ sex←guessSex(title forenames)
      sex←title{
          ⍺⊂rc∊'Mr' 'Sir':,'M'
          ⍺⊂rc∊'Miss' 'Ms' 'Mrs':,'F'
          0=⍴⍵:''
          nms←(up¨⍵/⍨1<⊃∘⍴∘,¨⍵)~COMMON              ⍝ up case; lose initials, and ambisexual names
          0=⍴nms:''
          pln hyp←nms∘(/⍨)¨↓0 1∘.='-'∊¨nms          ⍝ separate plain and hyphenated names
          all←pln,{⊃,/'-'part¨⍵}lz hyp              ⍝ split hyphenated names, append to pure ones
          {1=⍴⍵:⍵ ⋄ ''}'MF'/⍨×+/¨all∘∊¨BOYS GIRLS   ⍝ compare hits from each list
      }forenames
    ∇
    ∇ (title fore family)←interpret string;other;rest;tit;for;fam
      fam other←{','∊⊃⍵:(⊃⍵)(1↓⍵) ⋄ (⊃¯1↑⍵)(¯1↓⍵)}wordsFrom string
      tit rest←TITLES{(up ⍵⊃rc~'.')⊂rc∊⍺:(⊃⍵)(1↓⍵) ⋄ ''⍵}other
      for←{×⍴⍵:,⊃,/forenameOrInitial¨⍵ ⋄ ⍵},rest
      title fore family←titlecase¨tit for fam~¨⊂'.,'
    ∇
    ∇ z←forenameOrInitial string
      z←{
          1=⍴⍵:⊂⍵                           ⍝ an initial
          (∨/'AEIOU'∊up ⍵)∨'Y'∊up 1↓⍵:⊂⍵    ⍝ could be name
          ,¨⍵                               ⍝ >1 initials
      },string~'.'
    ∇
    ∇ words←wordsFrom string
      words←les' 'part(('.' '. ')(',' ', '))substitute string
    ∇
    
⍝                   HELP
    
    ∆←⊂'STEPHEN TAYLOR'
    ∆,←⊂'STEPHEN JOHN TAYLOR'
    ∆,←⊂'MR STEPHEN J.TAYLOR'
    ∆,←⊂'MR. S.J. TAYLOR'
    ∆,←⊂'S.J. TAYLOR'
    ∆,←⊂'TAYLOR, STEPHEN JOHN'
    ∆,←⊂'TAYLOR, SJ'
    ∆,←⊂'S. John Taylor'
    ∆,←⊂'MRS ASOKA GHOSH'
    ∆,←⊂'MS EMMA-SUE CHIPPERFIELD'
    ∆,←⊂'miss florence nightingale'
    ∆,←⊂'mrs asoka ghosh'
    ∆,←⊂'DR J CRIPPEN'
    ∆,←⊂'DR JOHN CRIPPEN'
    ∆,←⊂'JOHN Q POLICYHOLDER'
    :Field Public Shared SampleStrings←∆
    
    ∇ z←x nl y
      :Access Private Shared
      z←x,⎕TC[3],y
    ∇
    ∇ z←ul strings
      :Access Private Shared
      z←⊃nl/{(⌈/⊃∘⍴¨⍵)⍴¨⍵}strings
    ∇
    ∆←ul'=' 'Person class' '='
    ∆(nl)←''
    ∆(nl)←ul'Constructors: (eg)' '+'
    ∆(nl)←''
    ∆(nl)←'      ⎕NEW Person'
    ∆(nl)←'      ⎕NEW Person ''TAYLOR, STEPHEN JOHN'''
    ∆(nl)←'      ⎕NEW Person(''miss florence nightingale'' ''F'')'
    ∆(nl)←'      ⎕NEW Person((''Dr.Kenneth E.Iverson'')(''M'')(#.DateToIDN 1920 12 17))'
    ∆(nl)←''
    ∆(nl)←'See for examples'
    ∆(nl)←'      ↑Person.SampleStrings'
    ∆(nl)←''
    ∆(nl)←''
    ∆(nl)←'NB. setting Sex can cause Title to change'
    ∆(nl)←''
    ∆(nl)←ul'Methods:' '+'
    ∆(nl)←''
    ∆(nl)←ul'AgeAt IDN' '-'
    ∆(nl)←''
    ∆(nl)←ul'FormOfAddress - args (case insensitive)' '-'
    ∆(nl)←''
    ∆(nl)←'ENVELOPE:    as in 1st line on envelope address, eg Dr J.H. Smith'
    ∆(nl)←'FORMAL:      eg Sir'
    ∆(nl)←'FULL:        eg John Henry Smith'
    ∆(nl)←'INFORMAL:    eg Henry'
    ∆(nl)←'SEMIFORMAL:  eg Dr Smith'
    ∆(nl)←'TITLE:       eg Dr'
    ∆(nl)←''
    ∆(nl)←ul'HelloGoodbye - args (case insensitive)'  '-'
    ∆(nl)←''
    ∆(nl)←'FORMAL:      eg Dear Sir         Yours faithfully'
    ∆(nl)←'INFORMAL:    eg Dear Henry       Yours truly'
    ∆(nl)←'SEMIFORMAL:  eg Dear Dr Smith    Yours sincerely'
    ∆(nl)←''
    ∆(nl)←ul'Pronoun - args (case insensitive)' '-'
    ∆(nl)←''
    ∆(nl)←' 'join⊃∘(,/)¨PRONOUNS
    ∆(nl)←''
    ∆(nl)←'NB. methods display their valid arguments if passed an empty string'
    :Field Public Shared Help←∆
    
:EndClass ⍝ Person ⍝ Person  $Revision: 1472 $ 