﻿:Namespace Tools
⍝ Tools common between applications
⍝ Copyright 2006-7 Lambent Technology
    
    CASES←⎕AV[(⎕AV⍳'Aa')∘.+1-⍨⍳26]
    CR LF←⎕TC[2 3]
    TAB←10⊃⎕AV
    STRESSES←'AÀÄÅ' 'aàáâäå' 'cç' 'EÉ' 'eèéêë' 'iíîï' 'NÑ' 'nñ' 'OÖ' 'oóôöø' 'UÜ' 'uùúûü'
    LIGATURES←'ÆAE' 'æae' 'ØOE' 'øoe' 'ßSS'
    
   ⍝ text case
      shift←{
          from to←↓⍺
          (to,⎕AV)[⍵⍳⍨from,⎕AV]}
    dn←CASES∘shift                                          ⍝ shift string ⍵ to lower case
    up←(⊖CASES)∘shift                                       ⍝ shift string ⍵ to UPPER CASE
    
    among←∊⍨∘⊂⍨                                             ⍝ 'def'among'abc' 'def' 'ghi'
    any←×∘⊃∘⍴
    asDate←{⍺←{⍵} ⋄ #.DateToIDN ⍺ ⍺⍺ 3↑#.IDNToDate ⍵}       ⍝ perform ⍺⍺ on IDN ⍵ as a date
    BUT←{×⍴⍵:⍵ ⋄ ⍺}                                         ⍝ eg 'him'BUT'her'IF sex='F'
    car←{(⊃⍵)(1↓⍵)}                                         ⍝ cf Lisp
    due←{#.Clock.IDN≥#.DateToIDN ⍵}
    each←{1≥≡⍵:⍺⍺ ⍵ ⋄ ⍺⍺¨⍵}                                 ⍝ iterate ⍺⍺ if ⍵ list of strings
    empty←0∘∊∘⍴
    
    ∇ ok←EnsureDir path;⎕USING
      ⎕USING←'System' 'System.IO' 'File.IO'
      :If ~ok←Directory.Exists⊂path
          Directory.CreateDirectory⊂path                    ⍝ might need to handle exception...?
          ok←Directory.Exists⊂path
      :EndIf
    ∇
    
      gulpfile←{                                            ⍝ return file contents as a char vector
          22::''                                            ⍝ rewrite for .Net ...
          s←⎕NSIZE t←⍵ ⎕NTIE 0
          (⎕NUNTIE t){⍵}⎕NREAD t 82 s 0}
    
    if←{(⍺⍺⍣(⍵⍵ ⍵))⍵}                                       ⍝ eg ⊂if simple
    IF←/⍨                                                   ⍝ eg 'him'BUT'her'IF sex='F'
    isBetween←{1=⍺+.≥⍵}                                     ⍝ is ⍺ between ⍵ (exclusive)
    les←~∘∊⍨                                                ⍝ lose empty and all-blank strings (⎕ML 0)
    
      lineate←{
      ⍝ break text string ⍵ into lines of ≤⍺ chars
      ⍝ either at spaces or at \n
          0∊⍴⍵:''
          mx←1+⍺⌊⍴⍵
          take←(1-⍨1⍳⍨'\n'⍷⍵)⌊mx-' '⍳⍨⌽⍵↑⍨mx
          (⊂take↑⍵),⍺ ∇{⍵/⍨∨\⍵≠' '}{⍵↓⍨2×'\n'≡2↑⍵}take↓⍵
      }
    
⍝   lu←{k v←⍺ ⋄ v⊃⍨k⍳⊂⍵}                                    ⍝ look up ⍵ in dictionary ⍺
    
      lz←{                                                  ⍝ lazy: do nothing to empty ⍵
          ⍺←{⍵}                                             ⍝ provide for dyadic fn
          empty ⍵:''                                        ⍝ lose any prototype structure
          ⍺ ⍺⍺ ⍵}
    
    matrix←{2=⊃⍴⍴⍵}
    
      mesh←{
     ⍝ each member of ⍺ prefixes members of val for which key=⍺
     ⍝ eg 'Aaaa' 'B' 'Cc' ←→ 'ABC' mesh 'acacia' 'ACACIA'
          val key←(key∊⍺)∘/¨val key←⍵
          rnk←⍋⍺⍳key
          prt←1,2≠/key[rnk]
          msk←⍺∊key
          ⍺,¨msk/¨msk\prt⊂val[rnk]
      }
    
    part←{(⍴,⍺)↓¨⊂where(⍺∘⍷)⍺,⍵}                            ⍝ partition ⍵ at occurrences of ⍺
    quote←{'''',⍵,''''}
    rc←{(⍺⍺ ⍺)⍵⍵ ⍵}                                         ⍝ reverse compose
    
      RelativeDate←{
          ⍺←#.Clock.TS
          tm←{(×⍵)/,'G<Z9:Z9 >'⎕FMT ⍵}100⊥3↓5↑⍵
          ⊃≡/3↑¨⍺ ⍵:tm,'Today'
          1=-/#.DateToIDN¨⍺ ⍵:tm,'Yesterday'
          =/⊃¨⍺ ⍵:(⍕3⊃⍵),' ',3↑(2⊃⍵)⊃#.Constants.Months
          (⍕3⊃⍵),' ',(3↑(2⊃⍵)⊃#.Constants.Months),' ',⍕⊃⍵
      }
    
    rnd←{⍺×⌊0.5+⍵÷⍺}
    scalar←0∘=∘≡
    
      shortDate←{
          0 0 0≡y m d←3↑⍵:''
          ⊃,/¯2 3 ¯2↑¨⍕¨(d+100)(m⊃#.Constants.Months)(y)
      }
    
    simple←0 1∘(∊⍨)∘≡
    space←{⍺,' ',⍵}
      splitargs←{⍵∘(/⍨)¨↓1 0∘.=⍺∊⍨⊃¨⍵}∘,                      ⍝ split argt key/val pairs ⍵ according to keys ⍺
    
      substitute←{                                          ⍝ String replacement: ⍵ is ≡1 vector
          0∊⍴⍺:⍵                                            ⍝ ⍺ is vector of pairs of substrings
          0=⍴1⊃old new←,¨1⊃⍺:(1↓⍺)∇ ⍵                       ⍝ For each pair in ⍺, replace every
          msk←{
              0=∨/m←old⍷⍵:m                                 ⍝ look for old in ⍵
              >/⊃∘⍴¨old new:m                               ⍝ replace old if longer than new
              m∧~new⍷⍵                                      ⍝ else avoid
          }⍵
          ~∨/msk:(1↓⍺)∇ ⍵
          rplcd←⊃,/new∘,∘((⍴old)∘↓)¨msk⊂⍵                   ⍝ with second substring
          (1↓⍺)∇((∧\~msk)/⍵),rplcd}
    
      titlecase←{                                           ⍝ shift string or list of strings ⍵ to Title Case
          empty ⍵:''
          2=≡⍵:ttl¨⍵
          ' 'join ttl¨' 'part ⍵}
    
      ttl←{                                                 ⍝ shift string ⍵ to Title Case
          msk←(1↑⍨⍴⍵)∨¯1↓1,⍵='-'                            ⍝ 1st and following hyphens
          str←dn ⍵
          (msk/str)←up msk/str
          str}
    
    unq←{⍺←{⍵} ⋄ u←∪⍵ ⋄ ⍺(⍺⍺ u)[u⍳⍵]}                       ⍝ ⍺⍺ on unique elements of ⍵
    where←{(⍵⍵ ⍵)⍺⍺ ⍵}                                      ⍝ or {⍵ ⍺⍺⍨⍵⍵ ⍵} or {⍺⍺⍨∘⍵⍵⍨⍵}
    
      without←{                                             ⍝ ⍺⍺ on elements of ⍵ excluding ⍵⍵
          ⍺←{⍵}
          inc←~exc←⍵∊⍵⍵
          ∧/exc:⍵
          ∧/inc:⍺ ⍺⍺ ⍵
          r←inc\⍺ ⍺⍺ inc/⍵
          (exc/r)←exc/⍵
          r
      }
    
    ∇ {filepath}←txt writeAsFile filepath;fi;sw;⎕USING
     ⍝txt{(⎕NUNTIE ⍵){}⍺ ⎕NAPPEND 0 ⎕NRESIZE ⍵}{22::⍵ ⎕NCREATE 0 ⋄ ⍵ ⎕NTIE 0}filepath
      ⎕USING←'System' 'System.IO' 'File.IO'
      fi←⎕NEW FileInfo(⊂filepath)
      (fi.CreateText).Close                                 ⍝ destructive creation
      sw←fi.AppendText
      sw.WriteLine∘⊂¨linesof txt
      sw.Flush
      sw.Close
    ∇
    
    yrsBefore←{⍺ 0 0-⍨asDate ⍵}                             ⍝ IDN ⍵
    
   ⍝ compounds -----------------------------------------------------------------
    
    deb←/where({(>∘(<\)⍨⍣(~⊃⍵))⍵∨1↓⍵,0}∘{⍵≠' '})            ⍝ remove leading, trailing and multiple embedded blanks in ⍵)
    ds←{''}if empty                                         ⍝ destroy (prototype) structure
    enc←⊂if simple
    
      join←{⊃,∘(⍺∘,)/⍵}lz∘les                               ⍝ join non-empty strings in ⍵ with ⍺
    
    linesof←(CR∘part if simple)∘(↓if matrix)∘(,if scalar)   ⍝ nested vec from same, matrix, or vec with poss CRs
    rtb←↓where{-+/∧\' '=⌽⍵}                                 ⍝ remove trailing blanks
    xpnd←\where{1 0⍴⍨2×⍴⍵}                                  ⍝ double-space characters
    
   ⍝ HTML tools ----------------------------------------------------------------
    
      tag←{                                                 ⍝ eg 'P class="small"' tag line
          0∊⍴~∘∊⍨⍵:''                                       ⍝ eg 'UL'tag'LI'∘tag¨options
          tg←{'<',⍵,'>'}
          end←{'/',⍵/⍨∧\~⍵∊' :'}
          1=≡⍵:(tg ⍺),⍵,tg end ⍺
          (⊂tg ⍺),('  '∘,¨⍵),⊂tg end ⍺
      }
    
    BR←{⍵,¨(⌽0,1↓1⍴⍨⍴⍵)/¨⊂'<BR>'}                           ⍝ interpose HTML BR tags
    
    ∇ txt←DOCTYPE
      txt←'<!DOCTYPE HTML PUBLIC'
      txt,←' "-//W3C//DTD HTML 4.01//EN"'
      txt,←' "http://www.w3.org/TR/html4/strict.dtd">'
    ∇
    
    ∇ lines←HEAD;∆
      ∆←''
      ∆,←⊂'<link rel="stylesheet" type="text/css" href="file:///',#.Application.Root,'css/screen.css">'
      ∆,←⊂'<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">'
      ∆,←⊂'<meta name="author" content="Dyalog Ltd">'
      ∆,←⊂'<title>Dyalog | Customer Relationships</title>'
      lines←'HEAD'tag ∆
    ∇
    
   ⍝ see #.UI.HandleNavigation2 for discussion of the href attribute
      hlink←{
          class id←⍺
          ('A class="',(dn class),'" href="javascript://',class,' ',(⍕id),'"')tag ⍵
      }
    hyper←{⍺ ⍵.Value hlink ⍵.Text}                          ⍝ hyperlink from a ctl, eg 'Contacts'hyper ContactID
    
    HTML←{(⊂DOCTYPE),'HTML lang="en"'tag HEAD,('BODY id="',⍺,'"')tag ⍵}
    IMG←{'<IMG alt="',⍺,'" src="file:///',(#.Application.Root,⍵),'">'}
    
      PREHTML←{                                             ⍝ variant of HTML without indenting body
          middle end←{(¯4↓⍵)(¯2↑⍵)}'HTML lang="en"'tag HEAD,('BODY id="',⍺,'"')tag'not' 'this'
          (⊂DOCTYPE),middle,⍵,end
      }
    
    showdue←{('SPAN class="due"'∘tag⍣(due ⍵.Value))⍵.Text}  ⍝ highlight if due
    
   ⍝ handling INI files --------------------------------------------------------
    
      toIni←{                                               ⍝ apply ⍺⍺ to each section of INI file at path ⍵
          lineate←{⊃,/CR part¨LF part ⍵}                    ⍝ agnostic about exact use of CR/LF
          begins←{∨⌿⊃¨⍺∘.⍷⍵}
          notempty←×∘⊃∘⍴¨
          active←~∘(';' 'REM'∘begins)
          section←(,⊂'[')∘begins
          ⍺⍺¨(⊂where section)(/where active)(/where notempty)lineate gulpfile ⍵
      }
    
      getsIni←{                                             ⍝ read INI file path ⍵ and define contents in ns ⍺
          ⍺∘{
              hdr lines←(⊃⍵)(1↓⍵)
              nam←hdr~'[]'
              tabulate←↑∘((2∘⊃∘⎕VFI)¨)
              ∧/⊃⎕VFI⊃lines:nam ⍺.{⍎⍺,'←⍵'}tabulate lines   ⍝ assign section head to a numeric table in ns
              ∧/~'='∊¨lines:nam ⍺.{⍎⍺,'←⍵'}lines            ⍝ assign section head to a vtv in ns
              new←⎕NS''                                     ⍝ else assign section head to a ns of defined vars
              names strings←↓⍉↑'='∘part¨lines
              cnvrt←{m n←⎕VFI ⍵ ⋄ ∧/m:n ⋄ ⍵}                ⍝ convert to numeric if possible
              xxx←names new.{⍎⍺,'←⍵'}¨cnvrt¨strings
              nam ⍺.⎕NS new}toIni ⍵
      }
    
    spellings←{⊃,/{(1↓⍵){⍺ ⍵}¨⊂'[]'~⍨⊃⍵}toIni ⍵}            ⍝ string substitution pairs from INI file ⍵
    
:EndNamespace ⍝ Tools ⍝ Tools  $Revision: 1472 $ 