:Namespace names                ⍝ V1.02
⍝ Data generating namespace: Names, dates, adresses.

    cut←{⍺←' ' ⋄ 1↓¨(⍵∊⍺)⊂⍵}     ⋄ PrevRL←⎕rl ⋄ ⎕ml←1 ⋄ ⎕io←1 ⋄ ⎕rl←(¯2+2*31)|1×.⌈⎕ai

    _ ←'Aaron Abel Abelard Aberhard Abiah Abner Abraham Achilles Adair Adam Addis Adelard Adonis Ajax Alan Alastair Alaster Alban Albert Albion Alden Aldred Alexander '
    _,←'Alexis Alfred Alison Almeric Alonzo Aloysius Alphonso Alric Alroy Alston Alton Alvin Ambrose Amory Amyot Andrew Angus Anthony Archer Archibald Arden Argus '
    _,←'Arlen Arno Arnold Artemus Arthur Asa Asher Ashley Aubert Aubrey Auburn Augustus Austin Avery Bailey Baird Baldwin Barlow Barnabas Barner Barren Barron Barry '
    _,←'Barth Bartholomew Basil Baxter Belden Bellamy Benedict Beniah Benjamin Bentley Bergin Berman Bernard Bertram Bevis Bing Blair Blame Bob Bonar Boris Boyce '
    _,←'Bradford Bradley Brady Brandon Brant Brewster Brian Bruce Bruno Bryan Bryant Bryce Bryon Buck Burton Byrne Caesar Calbert Caleb Calvin Cameron Caradoc Carl '
    _,←'Carlos Carlyle Carol Carroll Carvel Cary Casey Casimir Caspar Cassidy Cecil Cedric Chaney Charles Chauncey Chester Christian Christopher Chuck Clair Clarence '
    _,←'Clark Clarke Claude Clay Clayton Clement Clifford Clifton Clinton Clive Clyde Cohn Colbert Colborn Colby Colin Colman Conan Conant Conrad Constantine Coolidge '
    _,←'Cordell Cornelius Cort Corwin Craig Crispin Crosby Cullen Curran Curt Curtis Cuthbert Cyril Cyrus Dale Dalton Dan Dana Daniel Darius Darrell David Dean Deane '
    _,←'Denman Dennis Derrick Dexter Dick Dillon Dirk Don Donald Dorian Douglas Dudley Duff Duke Duncan Dunstan Durand Durward Durwin Dwight Earle Eben Ebenezer Edbert '
    _,←'Eden Edgar Edmund Edsel Edward Edwin Egan Eghert Eldon Eli Elias Elihu Elijah Ellery Ellis Ellison Elmer Elmo Elroy Elsdon Elson Elsu Emanuel Embert Emery Emil '
    _,←'Emmett Eneas Enoch Enos Ephraim Erasmus Eric Erland Ernest Eros Errol Erwin Esmond Ethelbert Eugene Eustace Evald Evan Evelyn Everard Everett Ewan Ewart Ezra '
    _,←'Fairbanks Fairfax Farley Farquar Farrell Felix Feodore Ferdinand Fergus Filmer Fingal Flavian Francis Frank Frederick Gareth Gary Geoffrey George Gilles Glen '
    _,←'Glyn Godfrey Gordon Graham Grant Gustav Gustave Guy Guyenne Guyllum Hadwan Hal Halbert Haldane Hale Hamlyn Hardern Harlan Harley Harold Harrison Harry Hartley '
    _,←'Harvey Hector Henry Herbert Herman Hilary Hiram Hobart Holden Holman Homer Horace Horatio Howard Hoyt Hubert Hugh Hugo Humphrey Hyman Ian Ignatius Ingram Irvin '
    _,←'Irving Irwin Isaac Isadore Ivan Ivar Ivor Jack Jacob James Jarvis Jason Jaspar Jay Jed Jeffrey Jerel Jeremiah Jeremy Jerome Jerrold Jerry Jesper Jesse Jethro Jim Jimmy '
    _,←'Joab Jocelyn Jock Joel John Jonas Jonathan Joseph Joshua Joslyn Julian Julius Junius Justin Justus Kai Kane Karl Kaspar Kay Kean Keene Keith Kelby Kelcy Kelly '
    _,←'Kelsey Kelvin Kemper Kendal Kendall Kennard Kenneth Kent Kenton Kenyon Kerby Kerry Kerwin Kim Kirby Kirk Kit Konrad Koster Kowin Laban Lachlan Laird Lambert '
    _,←'Lancelot Landry Lang Latimer Laurence Lawrence Lawton Lazarus Leander Lear Ledyard Lee Leigh Leighton Leland Lemuel Lennox Leo Leon Leonard Leonidas Leopold '
    _,←'Leroy Les Leslie Lester Levi Lewis Lincoln Lindo Lionel Llewellyn Lloyd Loredo Loren Loring Lothario Louis Lowell Lucien Lucius Ludlow Ludovic Ludwig Luis Luke '
    _,←'Luther Lyle Lysandria Lyulfe Macey Macy Madoc Mafbus Malcolm Manchu Mandel Manfred Manley Manly Manoc Manuel Manus Manvil Marc Marcel March Marco Marcus Mario '
    _,←'Marion Mark Marlin Marlow Marmaduke Marmion Marshall Marston Martin Marvin Marwin Mathias Mato Matthew Maurice Max Maximilian Maxwell Maynard Medwin Meldon '
    _,←'Melvillo Melvin Melvyn Meredith Meredyth Merlin Merrell Merton Merwin Meyer Michael Milburn Miles Milton Mitchell Modoc Modred Montagu Montague Morel Morgan '
    _,←'Morley Morrell Morris Mortimer Morton Moses Murdoch Murray Nahum Napoleon Nash Nat Nathan Nathaniel Nato Neal Ned Neil Nelson Nestef Nevill Neville Newell Nial '
    _,←'Nicholas Nigel Niles Ninian Noah Noel Nolan Norard Norbert Norman Norris Nosveli Olaf Olin Oliver Omar Orin Orlando Orson Ortden Orval Orville Osbert Osborn '
    _,←'Osborne Oscard Osmund Osric Otto Otway Owen Paine Palmer Paly Parke Parker Patrick Paul Pawley Paxton Payton Percival Peregrine Peter Pheodor Philander '
    _,←'Philbert Philetus Phillip Philomon Phineas Piago Pierce Pierre Pius Pompey Powell Prescott Preston Prince Proctor Prosper Prospero Putman Quenton Quillon '
    _,←'Quincy Quinn Quintin Radcliffe Radford Ralph Ramsay Randall Randolph Ranger Raphael Raymond Raynard Redmond Redmund Regan Reginald Renfred Reuben Rex Rexford '
    _,←'Richard Richmond Ritchie Robert Robin Roderic Roderick Rodney Roger Roland Rollin Romeo Ronald Roolin Roscoe Ross Roswald Roswell Roy Royal Royd Royden Rudolph '
    _,←'Rudyard Ruford Rufus Rupert Russell Rutherford Ryan Sabin Salisbury Salmon Sampson Samson Samuel Sanders Sandon Sanford Saxon Schuyler Scott Sean Searle Sebold '
    _,←'Sedgwick Selby Selwyn Semar Senior Septimus Seth Sewell Seymour Shawn Shelby Shelley Sherard Sheridan Sherlock Sherwin Sibley Sidney Sigmund Sigurd Silas '
    _,←'Silvanus Silvester Simon Sinclair Solomon Spencer Stacey Stafford Stanley Stanton Stefan Stephen Sterling Stevan Steve Stewart Stuart Tague Talbot Tearle '
    _,←'Terence Terrence Tertius Thaddeus Theodore Theodoric Therold Theron Thomas Thurston Timothy Titus Tobias Tony Townsend Tracey Travers Trelawney Trevor Udo '
    _,←'Ulick Ulysses Upton Urban Uriab Uriel Urien Valdis Valentine Valerian Vandyke Varian Varney Vaughan Vernon Victor Vincent Virgil Vivian Vivien Vladimir Vyvyan '
    _,←'Wade Wadsworth Waldford Waldo Wallace Walmar Walmund Walter Warner Warren Warrick Warwick Wayne Wendel Wesley Whitney Wilbur Wilfred Willard William Willis '
    _,←'Willoughby Wilmer Winfred Wingard Winthrop Wirt Wyatt Wylie Wyndham Wynne Xavier Xenophon Yardley Yates Yeslin York Zabdiel Zachariah Zachary Zebulin Zelos '
    _,←'Kevin Chris Sam'
    Boys←cut _

    _ ←'Ada Adabel Adah Adalia Adamina Adelaide Adelberta Adele Adelia Adeline Adella Adelma Adelphe Adina Adonia Adora Adosinda Adria Adriana Adrienne Agatha Agnes '
    _,←'Aileen Aimee Aine Alanna Alarice Alberta Albertina Albertine Alda Aldora Aleta Aletea Alexandra Alexis Alfonsina Alfreda Alice Alicia Alison Allegra Alma '
    _,←'Almina Almira Alodie Aloys Aloyse Alta Althea Alva Alvina Alvita Alys Amabel Amala Amanda Amara Amaryllis Amelia Amethyst Aminta Amity Amorita Amy Anastasia '
    _,←'Andrea Angela Angeline Anita Ann Anna Anne April Arabella Ardelle Ariadne Arlene Arlette Asoka Astra Astrid Athel Athena Audrey Augusta Aurora Babette Baptista '
    _,←'Barbara Barnardine Bathilde Beatrice Belinda Bella Bellance Benedotte Benita Bernadette Bernette Bernice Bertha Bertina Beryl Bess Bessie Beth Bettina Betty '
    _,←'Beulah Bianca Birdona Blanche Blessing Blossom Blythe Bonita Bonnibella Brenda Brenna Briana Bridget Brigitta Brunella Callandra Callista Camilla Candico '
    _,←'Candida Cara Carlita Carlotta Carma Carmen Carmine Carol Carole Caroline Cassandra Catherine Cathleen Cecania Cecilia Celeste Celestia Celia Celina Cerise '
    _,←'Chala Charity Charlina Charlotte Charmain Chelsea Cherry Chloe Christabel Christine Cicily Clair Claribel Clarice Clarinda Claude Claudette Claudia Cleantha Clematis Cleo '
    _,←'Cleopatra Clorinda Clotilde Coleen Collette Columbia Comela Connie Constance Cora Coraho Cordelia Corinne Crystal Cynthia Dagmar Dahlia Daisy Dama Damaris '
    _,←'Dance Danella Danita Daphne Dara Darline Daryl Dawn Deanna Deborah Deirdre Delia Delicia Delila Della Denise Desiree Desma Diana Diantha Dinah Dolores Donna '
    _,←'Dora Dorcas Dorinda Doris Dorothy Drusilla Dulcie Easter Ebba Echo Eda Edda Edina Edith Edna Edra Edwina Eileen Elaine Elberta Eleanor Elga Elise Eliza '
    _,←'Elizabeth Ella Ellen Ellissa Elma Elnora Eloise Elsie Elspeth Elvina Elvira Elysia Emily Emilia Emma Emogene Enid Enrica Eolande Erasma Erdine Erica Erina '
    _,←'Erline Ermina Erna Esme Esmeralda Estella Esther Ethel Etta Eunice Eustacia Eva Evadne Eve Eveline Evelyn Faith Fanchon Fanny Farica Fawn Fay Fayette Fedoria '
    _,←'Felicity Fern Fidelia Filipa Fiti Flavia Fleta Flora Florence Floris Fonda Fortune Frances Francine Freda Fresa Gabrielle Gail Garda Gardenia Gay Gazelle '
    _,←'Geneva Genevieve Genevra Georgette Geraldine Germaine Gertrude Gilberta Gilda Gladys Gleda Glenna Godiva Grace Gracia Greta Gretchen Griselda Gwen Gwendoline '
    _,←'Gwynne Gyda Gytha Haidee Haldana Halfrida Hannah Harriet Hatty Hazel Heather Hedda Hedia Hedy Helen Helene Helga Heliose Helsa Henrietta Henrika Hermione '
    _,←'Hertha Hester Hetty Hilda Hildegarde Hilma Holly Honora Hope Huberta Hyacinth Hypatia Ianthe Ida Idella Idena Idette Ilka Imogen Ina Inga Ingrid Iona Ireland '
    _,←'Irene Irina Iris Irma Irvette Isa Isabel Isobel Isolde Ita Iva Ivy Jacalyn Jacinta Jacintha Jaclyn Jacqueline Jama Jane Janet Jasmine Jean Jeanette Jeanne Jelena '
    _,←'Jemima Jennifer Jenny Jessica Jewel Jill Joan Joanna Joanne Jobina Jocelyn Jodetha Johanna Joletta Josephine Joy Joyce Juanita Judith Judy Julia Juliana Julie '
    _,←'Juliet Julita June Justina Justine Kama Karen Kasia Katherine Kathleen Kathryn Katrina Katrine Kay Kelly Kirsten Kirstin Kneta Koren Kyna Lala Lana Lanette '
    _,←'Lara Laraine Larine Larissa Laura Lauren Laveda Lavinia Lemuela Lena Lenor Leoda Leola Leoma Leona Leoni Leonora Leora Lesley Leslie Leta Letitia Letty Lexine '
    _,←'Liane Libby Lilac Lilah Lilian Lilias Lillybell Lily Linda Linette Linnea Lisbeth Livia Lodema Lois Lolita Lorella Lorena Loretta Lorinda Lorna Lotty Lotus '
    _,←'Louise Louslla Lucia Luciana Lucille Lucinda Lucretia Ludella Ludmilla Lugene Luna Lupe Luvena Luzette Lydia Lynette Lynne Mabel Mabelle Madalyn Madeline '
    _,←'Madella Madge Madra Mae Magdala Magdalene Magnild Magnolia Maidene Maisie Majesta Malca Malina Malva Manette Manuela Marcella Marelda Margaret Margery Margot '
    _,←'Maria Marian Marigold Marilyn Marina Marjory Marlena Marlene Martha Martina Mary Matilda Maud Maureen Mavis Maxine May Meda Megan Melanie Melinda Melissa '
    _,←'Melita Melody Melosa Melva Mercy Meris Merle Meta Michaela Michele Mignon Mildred Millicent Mimi Mina Minerva Miranda Miriam Modesta Moira Mona Monica Morny Muriel '
    _,←'Myra Myriam Myrtle Nada Nadine Naida Nana Nancy Nanelle Nanette Naomi Nara Narcisse Nata Natalie Natasha Nathania Nellwyn Neoma Nerine Nerissa Nesta Nettie Nevaeda '
    _,←'Neyasa Nicole Nina Nita Noda Noella Noelle Nola Nona Nora Norma Noverta Novia Nydia Octavia Odella Odile Olga Olive Olivia Ondine One Opal Ora Oriel Orlana '
    _,←'Orlona Orrila Osberta Otila Pallas Palma Palmeda Palmyra Pamela Pansy Parthenia Patience Patricia Patsy Paula Paulette Pauline Pearl Peggy Penelope Penthea '
    _,←'Peony Pepita Pernella Persephone Persis Petronella Petunia Pheodora Phila Philana Philberta Philippa Philomena Phoebe Phyllis Placida Poppy Portia Prima '
    _,←'Primrose Priscilla Prudence Psyche Queenie Quintina Rachel Radella Rafaela Ramona Reba Rebecca Regina Reina Renata Renee Renita Rhea Rhoda Richela Rita Riva '
    _,←'Roberta Robina Roderica Rolanda Roma Ronalda Rosalie Rosalind Rosalyn Rosanna Rose Rosemary Rosette Rosina Rowena Roxanna Rubetta Ruby Rudelle Rue Ruth Sabina '
    _,←'Sabrina Sacha Sadelle Sadie Saline Sally Salome Samantha Samara Samela Sandra Sapphira Sara Sarah Sarotta Sebastiana Secunda Sela Selena Selima Selma Septima '
    _,←'Seraphine Serena Sharon Sheelah Sheila Sibley Sidonia Sidonie Sidra Sigourney Sigrid Silva Silver Silvia Simona Simone Siona Sonia Sophia Sophie Sophronia '
    _,←'Sophy Stefanie Stella Sue Susan Susanna Susannah Susanne Susette Suzanne Suzette Sybil Sylvana Sylvia Tabitha Tacita Talitha Tallula Tamara Tara Temperence '
    _,←'Teresa Terry Tertia Tess Tessa Thaddea Thadine Thais Thalida Thea Thecla Theda Thekla Thelma Theodora Theodosia Theophila Thera Theresa Thirza Thomasine '
    _,←'Thomasma Thora Thyrsa Tilda Tilly Timotea Timothea Tita Titania Tomarra Tomasa Tomida Tonia Topaza Tourmaline Tracey Trina Trista Trixy Tybal Uda Udele Ula '
    _,←'Ulette Ulrica Una Undine Urania Ursa Ursal Ursula Ursynetta Val Valda Valencia Valenia Valentine Valera Valerie Vanessa Vanetta Vania Varette Vashti Veda Velda '
    _,←'Velma Venda Venita Vera Veral Verbena Verbette Verda Verina Verna Verne Veta Victoria Victorine Vida Vidette Vilma Vincentia Viola Violet Violetta Violette '
    _,←'Virginia Vita Vivian Vivienne Vivietta Vyona Wahkona Wallis Walpurga Wanda Wannette Wapoka Wardena Wenda Wendelin Wendy Wenona Wileen Willa Willette Wilma '
    _,←'Wilmet Winetta Winifred Winnie Winona Wuhelmina Wylma Wynne Xena Xenia Ximena Xylia Xylina Xylona Yedda Yola Yolanda Yolande Yolanthe Ysolde Yvette Yvonne '
    _,←'Zandra Zelda Zena Zenia Zenobia Zeonora Zoe Zorah'
    Girls←cut _

    _← ' Adams Alexander Ali Allen Anderson Bailey Baker Barnes Barnet Barnett Bell Bennett Bouchard Brooks Brown Butler Campbell Carter Clark Clarke'
    _,←' Collins Cook Cooper Cox Cruz Côté Davies Davis Doherty Driscoll Díaz Edwards Evans Fisher Flores Fortin Foster Gagnon Gagné'
    _,←' García Gauthier González Graham Gray Green Griffiths Gutiérrez Gómez Hall Hamilton Harris Hernandez Hernández Hill Howard'
    _,←' Hughes Jackson James Jenkins Johnson Johnston Jones Kelly Khan King Lavoie Lee Lewis Long López MacDonald Martin Martínez'
    _,←' Mason McLaughlin Miller Mitchell Moore Morales Morgan Morin Morris Moss Murphy Murray Myers Nelson Nguyen Ortiz Owen O''Connor O''Neill'
    _,←' Parker Patel Perry Peterson Phillips Powell Price Pérez Quinn Ramírez Reed Rees Reid Reyes Richardson Rivera Roberts Robertson'
    _,←' Robinson Rodríguez Rogers Rose Ross Roy Russell Sanders Scott Smith Smyth Stewart Sullivan Sánchez Taylor Thomas Thompson'
    _,←' Thomson Torres Tremblay Turner Walker Ward Watson White Williams Wilson Wong Wood Wright Young'
    Surnames←cut _

    _,←';Aachen,Germany;Aba,Nigeria;Abaeteluba,Brazil;Abakan,Russia;Abeokuta,Nigeria;Aberdeen,United Kingdom;Abidjan,Cote dIvoire;Abiko,Japan'
    _,←';Abilene,USA;Abohar,India;Abu Dhabi,United Arab Emirates;Acapulco,Mexico;Acarigua-Araure,Venezuela;Accra,Ghana;Achinsk,Russia'
    _,←';Adamstown,Pitcairn;Adana,Turkey;Adapazari,Turkey;Addis Ababa,Ethiopia;Adelaide,Australia;Adhamiyah,Iraq;Adiyaman,Turkey'
    _,←';Ado-Ekiti,Nigeria;Adoni,India;Afyon,Turkey;Agadir,Morocco;Agana,Guam;Agra,India;Ahmedabad,India;Ahwaz,Iran;Aix-en-Provence,France'
    _,←';Akron,USA;Albany,USA;Albuquerque,USA;Aleppo,Syrian Arab Republic;Alexandria,Egypt;Alexandria,USA;Alger,Algeria;Allahabad,India'
    _,←';Allentown,USA;Almaty,Kazakstan;Amarillo,USA;Amber Valley,United Kingdom;Amiens,France;Amman,Jordan;Amritsar,India;Amsterdam,Netherlands'
    _,←';Anaheim,USA;Anchorage,USA;Angers,France;Ankang,China;Ankara,Turkey;Anlu,China;Ann Arbor,USA;Anshan,China;Anshun,China;Antalya,Turkey'
    _,←';Anyang,China;Arequipa,Peru;Arlington,USA;Arun,United Kingdom;Ashfield,United Kingdom;Asuncion,Paraguay;Athinai,Greece;Atlanta,USA'
    _,←';Aurangabad,India;Aurora,USA;Austin,USA;Avellaneda,Argentina;Ayacucho,Peru;Aydin,Turkey;Aylesbury Vale,United Kingdom;Baghdad,Iraq'
    _,←';Baku,Azerbaijan;Babol,Iran;Bac Lieu,Vietnam;Bacau,Romania;Bacolod,Philippines;Badajoz,Spain;Badalona,Spain;Bage,Brazil;Bago,Philippines'
    _,←';Baguio,Philippines;Baharampur,India;Bahawalpur,Pakistan;Bahia Blanca,Argentina;Bahir Dar,Ethiopia;Bahraich,India;Baia Mare,Romania'
    _,←';Baicheng,China;Baihua,China;Baise,China;Baiyin,China;Bakersfield,USA;Balakovo,Russia;Balashikha,Russia;Baleshwar,India;Baltimore,USA'
    _,←';Barking and Dagenham,United Kingdom;Barnet,United Kingdom;Barnsley,United Kingdom;Basildon,United Kingdom'
    _,←';Basingstoke,United Kingdom;Bassetlaw,United Kingdom;Baton Rouge,USA;Beaumont,USA;Bedford,United Kingdom;Belfast,United Kingdom'
    _,←';Besançon,France;Beverley,United Kingdom;Bexley,United Kingdom;Birmingham,United Kingdom;Birmingham,USA;Blackburn,United Kingdom'
    _,←';Blackpool,United Kingdom;Bloemfontein,South Africa;Blumenau,Brazil;Boa Vista,Brazil;Bobo Dioulasso,Burkina Faso;Bobruisk,Belarus'
    _,←';Bochum,Germany;Bodong,China;Bogor,Indonesia;Boise City,USA;Bojnurd,Iran;Bokaro Steel City,India;Boksburg,South Africa;Bologna,Italy'
    _,←';Bolton,United Kingdom;Bolzano,Italy;Boma,Congo;Bombay,India;Bonn,Germany;Boras,Sweden;Bordeaux,France'
    _,←';Borisov,Belarus;Borujerd,Iran;Boshan,China;Boston,USA;Botosani,Romania;Botou,China;Botshabelo,South Africa;Bottrop,Germany'
    _,←';Bouake,Cote dIvoire;Bourgas,Bulgaria;Bournemouth,United Kingdom;Bracknell Forest,United Kingdom;Bradford,United Kingdom'
    _,←';Braintree,United Kingdom;Brampton,Canada;Breckland,United Kingdom;Brent,United Kingdom;Brest,France;Bridgeport,USA'
    _,←';Brighton,United Kingdom;Bristol,United Kingdom;Broadland,United Kingdom;Bromley,United Kingdom;Brownsville,USA;Broxtowe,United Kingdom'
    _,←';Buffalo,USA;Burlington,Canada;Burnaby,Canada;Béni-Mellal,Morocco;Charlotte Amalie,USA Virgin Islands;Caen,France;Calgary,Canada'
    _,←';Cedar Rapids,USA;Chandler,USA;Chapra,India;Chardzhou,Turkmenistan;Charleroi,Belgium;Charlotte,USA;Charnwood,United Kingdom'
    _,←';Chattanooga,USA;Cheboksary,Russia;Cheju,South Korea;Chelmsford,United Kingdom;Cheltenham,United Kingdom;Chelyabinsk,Russia'
    _,←';Chemnitz,Germany;Chengde,China;Chengdu,China;Chenghwa,China;Chenzhou,China;Cheonan,South Korea;Cheongju,South Korea;Cherepovets,Russia'
    _,←';Cherkassy,Ukraine;Cherkessk,Russia;Chernigov,Ukraine;Chernovtsy,Ukraine;Cherthala,India;Cherwell,United Kingdom;Chesapeake,USA'
    _,←';Chester,United Kingdom;Chesterfield,United Kingdom;Chiang Mai,Thailand;Clermont-Ferrand,France;Dhaka,Bangladesh;Dili,East Timor'
    _,←';Dodoma,Tanzania;Doha,Qatar;Dewas,India;Deyang,China;Dezful,Iran;Dezhou,China;Dhanbad,India;Dhule,India;Diadema,Brazil;Dibrugarh,India'
    _,←';Dijon,France;Dimitrovgrad,Russia;Dinajpur,Bangladesh;Dindigul,India;Dingzhou,China;Diredawa,Ethiopia;Divinópolis,Brazil;Diwaniya,Iraq'
    _,←';Diyarbakir,Turkey;Djizak,Uzbekistan;Djougou,Benin;Dlepmealow,South Africa;Dneprodzerzhinsk,Ukraine;Dnepropetrovsk,Ukraine'
    _,←';Doboj,Bosnia and Herzegovina;Dobritch,Bulgaria;Doncaster,United Kingdom;Donetsk,Ukraine;East Hampshire,United Kingdom'
    _,←';East Hertfordshire,United Kingdom;East Lindsey,United Kingdom;East York,Canada;Eastleigh,United Kingdom;Edinburgh,United Kingdom'
    _,←';Edmonton,Canada;Elmbridge,United Kingdom;Enfield,United Kingdom;Epping Forest,United Kingdom;Erewash,United Kingdom;Etobicoke,Canada'
    _,←';Exeter,United Kingdom;Falkirk,United Kingdom;Fareham,United Kingdom;Fresno,USA;Fullerton,USA;Funabashi,Japan;Funchal,Portugal'
    _,←';Fushun,China;Fuxin,China;Fuyang,China;Fuyu,China;Fuzhou,China;Goborone,Botswana;Gadag-Betgeri,India;Galati,Romania;Galle,Sri Lanka'
    _,←';Gandhidham,India;Gandhinagar,India;Ganganagar,India;Gangreung,South Korea;Ganzhou,China;Gaocheng,China;Gaoxiong,China;Garanhuns,Brazil'
    _,←';Garden Grove,USA;Garland,USA;Gary,USA;Gateshead,United Kingdom;Gaya,India;Gaziantep,Turkey;Gdansk,Poland;Gedling,United Kingdom'
    _,←';Glasgow,United Kingdom;Glendale,USA;Gloucester,Canada;Gloucester,United Kingdom;Grand Prairie,USA;Grand Rapids,USA;Green Bay,USA'
    _,←';Greensboro,USA;Greenwich,United Kingdom;Grenoble,France;Guildford,United Kingdom;Gómez Palacio,Mexico;Göteborg,Sweden;Göttingen,Germany'
    _,←';HELSINKI,Finland;Hackney,United Kingdom;Halifax,Canada;Halton,United Kingdom;Hamilton,Canada;Hamilton,United Kingdom'
    _,←';Hammersmith and Fulham,United Kingdom;Hampton,USA;Haringey,United Kingdom;Harrogate,United Kingdom;Harrow,United Kingdom;Hartford,USA'
    _,←';Havant and Waterloo,United Kingdom;Havering,United Kingdom;Hayward,USA;Hebi,China;Hechi,China;Hefei,China;Hegang,China'
    _,←';Heidelberg,Germany;Heihe,China;Heilbronn,Germany;Helsingborg,Sweden;Henderson,USA;Hengshui,China;Hengyang,China;Herat,Afghanistan'
    _,←';Hermosillo,Mexico;Herne,Germany;Hetian,China;Heyuan,China;Heze,China;Hialeah,USA;Higashihiroshima,Japan;Higashikurume,Japan'
    _,←';Higashimurayama,Japan;Higashiosaka,Japan;Hikone,Japan;Hildesheim,Germany;Hilla,Iraq;Hillingdon,United Kingdom;Himeji,Japan'
    _,←';Hindupur,India;Hino,Japan;Hollywood,USA;Honolulu,USA;Horsham,United Kingdom;Hounslow,United Kingdom;Houston,USA;Huntington Beach,USA'
    _,←';Huntsville,USA;Independence,USA;Indianapolis,USA;Inglewood,USA;Irvine,USA;Irving,USA;Jackson,USA;Jacksonville,USA;Jersey City,USA'
    _,←';Ji-Paraná,Brazil;Jiangmen,China;Jiaojing,China;Jiaozuo,China;Jiaxing,China;Jiayi,China;Jiayuguan,China;Jieshou,China;Jilin,China'
    _,←';Jilon,China;Jimma,Ethiopia;Jinan,China;Jinchang,China;Jincheng,China;Jingdezhen,China;Jingmen,China;Jinhua,China;Jinin,China'
    _,←';Jinxi,China;Jinzhou,China;Jisou,China;Jiujiang,China;Jiuquan,China;Jixi,China;Joao Pessoa,Brazil;Joetsu,Japan;Johannesburg,South Africa'
    _,←';Johore Bharu,Malaysia;Joinville,Brazil;Jönköping,Sweden;Kansas City,USA;Kitchener,Canada;Kokubanji,Japan;Kolhapur,India;Kollam,India'
    _,←';Kolomna,Russia;Kolpino,Russia;Kolwezi,Congo;Komaki,Japan;Komatsu,Japan;Komsomolsk-na-Amure,Russia'
    _,←';Konotop,Ukraine;Konstantinovka,Ukraine;Konya,Turkey;Korba,India;Korhogo,Cote dIvoire;Koriyama,Japan;Korla,China;Kortrijk,Belgium'
    _,←';Koshigaya,Japan;Kosice,Slovakia;Kostroma,Russia;Koszalin,Poland;Kota Bahru,Malaysia;Kota Kinabalu,Malaysia;Kota,India;Kothagudem,India'
    _,←';Kottayam,India;Kotte,Sri Lanka;Kovrov,Russia;Kozhikode,India;Kragujevac,Serbia and Montenegro;Lusaka,Zambia;Luxembourg,Luxembourg'
    _,←';Laval,Canada;Le Havre,France;Le Mans,France;Lille,France;Limoges,France;Linköping,Sweden;London,Canada;Longueuil,Canada'
    _,←';Los Teques,Venezuela;Loudi,China;Louisville,USA;Luan,China;Luanshya,Zambia;Lubbock,USA;Lublin,Poland;Lubumbashi,Congo'
    _,←';Lucena City,Philippines;Lucknow,India;Ludhiana,India;Ludwigshafen am Rhein,Germany;Lugansk,Ukraine;Luohe,China;Luoyang,China'
    _,←';Luton,United Kingdom;Lutsk,Ukraine;Luxer,Egypt;Luzern,Switzerland;Luzhou,China;Luziania,Brazil;Lvov,Ukraine;Lyon,France'
    _,←';Lyubertsy,Russia;Mogadishu,Somalia;Monaco,Monaco;Monrovia,Liberia;Malmö,Sweden;Markham,Canada;Marseille,France;Metz,France;Mishan,China'
    _,←';Mishima,Japan;Miskolc,Hungary;Mississauga,Canada;Misurata,Libya;Mitaka,Japan;Mito,Japan;Miyakonojo,Japan;Miyazaki,Japan;Mobile,USA'
    _,←';Modena,Italy;Modesto,USA;Modinagar,India;Moers,Germany;Moga,India;Mogilev,Belarus;Mogpo,South Korea;Mohammedia,Morocco'
    _,←';Moji das Cruzes,Brazil;Moji-Guaçu,Brazil;Mojokerto,Indonesia;Mombasa,Kenya;Monclova,Mexico;Monklands,United Kingdom;Mons,Belgium'
    _,←';Monteria,Colombia;Monterrey,Mexico;Montpellier,France;Montreal,Canada;Motherwell,United Kingdom;Mulhouse,France;Málaga,Spain'
    _,←';Mérida,Mexico;Mérida,Venezuela;Móstoles,Spain;Noumea,New Caledonia;Nantes,France;Nepean,Canada;New Forest,United Kingdom;New Haven,USA'
    _,←';New Orleans,USA;New York,USA;Sherwood,United Kingdom;Newark,USA;Newbury,United Kingdom;Newcastle upon Tyne,United Kingdom'
    _,←';Newcastle-under-Lyme,United Kingdom;Newham,United Kingdom;Newport News,USA;Newport,United Kingdom;Nice,France;Nimes,France;Nobeoka,Japan'
    _,←';Noda,Japan;Nogales,Mexico;Noginsk,Russia;Noida,India;Nonthaburi,Thailand;Norfolk,USA;Norilsk,Russia;Norrköping,Sweden'
    _,←';North Hertfordshire,United Kingdom;North Tyneside,United Kingdom;North Wiltshire,United Kingdom;North York,Canada'
    _,←';Northampton,United Kingdom;Northavon,United Kingdom;Northshore,New Zealand;Norwalk,USA;Norwich,United Kingdom;Nottingham,United Kingdom'
    _,←';Nova Friburgo,Brazil;Nova Iguaçu,Brazil;Novara,Italy;Novgorod,Russia;Novi Sad,Serbia and Montenegro;Novo Hamburgo,Brazil'
    _,←';Novocheboksarsk,Russia;Novocherkassk,Russia;Novokuybishevsk,Russia;Novokuznetsk,Russia;Nuneaton & Bedworth,United Kingdom;Ottawa,Canada'
    _,←';Oakland,USA;Oakville,Canada;Oceanside,USA;Ogwr,United Kingdom;Oklahoma City,USA;Oldham,United Kingdom;Omaha,USA;Ontario,USA;Orange,USA'
    _,←';Orlando,USA;Orléans,France;Oshawa,Canada;Overland Park,USA;Oxford,United Kingdom;Oxnard,USA;Paris,France;Phnom Penh,Cambodia'
    _,←';Palmdale,USA;Pasadena,USA;Paterson,USA;Penza,Russia;Peoria,USA;Pereira,Colombia;Perm,Russia;Perpignan,France'
    _,←';Perth and Kinross,United Kingdom;Perth,Australia;Perugia,Italy;Pervouralsk,Russia;Pescara,Italy;Peshawar,Pakistan;Petah Tiqwa,Israel'
    _,←';Petaling Jaya,Malaysia;Petare,Venezuela;Peterborough,United Kingdom;Petrolina,Brazil;Petropavlovsk,Kazakstan'
    _,←';Petropavlovsk-Kamchatsky,Russia;Petrozavodsk,Russia;Petrópolis,Brazil;Pforzheim,Germany;Philadelphia,USA;Phoenix,USA;Piacenza,Italy'
    _,←';Piatra Neamt,Romania;Pietermaritzburg,South Africa;Pilibhit,India;Pinar del Río,Cuba;Pindamonhangaba,Brazil;Pisa,Italy;Pittsburgh,USA'
    _,←';Plano,USA;Plymouth,United Kingdom;Pomona,USA;Poole,United Kingdom;Portland,USA;Portsmouth,United Kingdom;Portsmouth,USA;Prato,Italy'
    _,←';Preston,United Kingdom;Providence,USA;Pueblo,USA;Québec,Canada;Reykjavik,Iceland;Riga,Latvia;Riyadh,Saudi Arabia'
    _,←';Road Town,British Virgin Islands;Rome,Italy;Ravenna,Italy;Reading,United Kingdom;Redbridge,United Kingdom;Reggio di Calabria,Italy'
    _,←';Reggio nellEmilia,Italy;Regina,Canada;Reigate and Banstead,United Kingdom;Reims,France;Renfrew,United Kingdom;Rennes,France'
    _,←';Reutlingen,Germany;Rewa,India;Reynosa,Mexico;Rhymney Valley,United Kingdom;Ribeirao Preto,Brazil;Ribeirao das Neves,Brazil'
    _,←';Richmond upon Thames,United Kingdom;Richmond,Canada;Richmond,USA;Rijeka,Croatia;Rimini,Italy;Rimnicu Vilcea,Romania;Rio Branco,Brazil'
    _,←';Rio Claro,Brazil;Rio Cuarto,Argentina;Rio Grande,Brazil;Rio de Janeiro,Brazil;Rishon Leziyyon,Israel;Riverside,USA;Rizhao,China'
    _,←';Rochdale,United Kingdom;Rochester,USA;Rochester-upon-Medway,United Kingdom;Rockford,USA;Rohtak,India;Rouen,France;Seoul,South Korea'
    _,←';Stockholm,Sweden;Saint-Etienne,France;Salerno,Italy;Saskatoon,Canada;Sasolburg,South Africa;Sassari,Italy;Satna,India;Satu-Mare,Romania'
    _,←';Savannah,USA;Sayama,Japan;Scarborough,Canada;Scarborough,United Kingdom;Schwerin,Germany;Scottsdale,USA;Seattle,USA'
    _,←';Sedgemoor,United Kingdom;Sefton,United Kingdom;Semarang,Indonesia;Semipalatinsk,Kazakstan;Sendai,Japan;Seongnam,South Korea'
    _,←';Serampore,India;Seremban,Malaysia;Sergiev Posad,Russia;Serov,Russia;Serpukhov,Russia;Serra,Brazil;Sete Lagoas,Brazil;Setif,Algeria'
    _,←';Seto,Japan;Setubal,Portugal;Sevastopol,Ukraine;Sevenoaks,United Kingdom;Severodonetsk,Ukraine;Severodvinsk,Russia;Seville,Spain'
    _,←';Shahe,China;Shahjahanpur,India;Shakhty,Russia;Shanghai,China;Shangqiu,China;Shangrao,China;Shangzhi,China;Shangzhou,China;Shantou,China'
    _,←';Shanwei,China;Shanzhong,China;Shaoguan,China;Shaown,China;Shaoxing,China;Shaoyang,China;Sharjah,United Arab Emirates;Shashi,China'
    _,←';Shauliai,Lithuania;Shchelkovo,Russia;Shebin-El-Kom,Egypt;Sheffield,United Kingdom;Sheikhu Pura,Pakistan;Shenyang,China;Shenzhen,China'
    _,←';Shihezi,China;Shihung,South Korea;Siracusa,Italy;Springfield,USA;St. Catharines,Canada;St. Helens,United Kingdom;St. Louis,USA'
    _,←';St. Paul,USA;St. Petersburg,USA;Stafford,United Kingdom;Sterling Heights,USA;Stockport,United Kingdom;Stockton,USA'
    _,←';Stockton-on-Tees,United Kingdom;Stoke on Trent,United Kingdom;Strasbourg,France;Stratford-upon-Avon,United Kingdom;Stroud,United Kingdom'
    _,←';Suffolk Coastal,United Kingdom;Sunderland,United Kingdom;Sunnyvale,USA;Surrey,Canada;Sutton,United Kingdom;Swale,United Kingdom'
    _,←';Swansea,United Kingdom;Syracuse,USA;Szczecin,Poland;Szeged,Hungary;Székesfehérvár,Hungary;Taboao da Serra,Brazil;Tabora,Tanzania'
    _,←';Tabriz,Iran;Tachikawa,Japan;Tacloban,Philippines;Tacna,Peru;Tacoma,USA;Taff-Ely,United Kingdom;Taganrog,Russia;Taguig,Philippines'
    _,←';Taian,China;Taif,Saudi Arabia;Tainan,China;Taipei,Taiwan;Taiping,Malaysia;Taiyan,China;Taizhong,China;Takamatsu,Japan;Takaoka,Japan'
    _,←';Takarazuka,Japan;Takasaki,Japan;Takatsuki,Japan;Talca,Chile;Talcahuano,Chile;Taldikorgan,Kazakstan;Tallahassee,USA'
    _,←';Tameside,United Kingdom;Tampa,USA;Taranto,Italy;Teignbridge,United Kingdom;Tempe,USA;Tendring,United Kingdom;Terni,Italy'
    _,←';Test Valley,United Kingdom;Thamesdown,United Kingdom;Thanet,United Kingdom;The Wrekin,United Kingdom;Thousand Oaks,USA;Thunder Bay,Canada'
    _,←';Thurrock,United Kingdom;Toledo,USA;Tonbridge and Malling,United Kingdom;Topeka,USA;Torbay,United Kingdom;Torino,Italy;Toronto,Canada'
    _,←';Torrance,USA;Torre del Greco,Italy;Tower Hamlets,United Kingdom;Trafford,United Kingdom;Treviso,Italy;Trieste,Italy;Tucson,USA;Tulsa,USA'
    _,←';Tunbridge Wells,United Kingdom;Tuzla,Bosnia and Herzegovina;Tver,Russia;Tychy,Poland;Tyumen,Russia;Tétouan,Morocco;Ulaanbaatar,Mongolia'
    _,←';Ube,Japan;Uberaba,Brazil;Uberlandia,Brazil;Ubon Ratchathani,Thailand;Udaipur,India;Udine,Italy;Ueda,Japan;Ufa,Russia;Uhta,Russia'
    _,←';Uji,Japan;Ujjain,India;Ujung Pandang,Indonesia;Ulan Hot,China;Ulan-Ude,Russia;Ulhasnagar,India;Ulm,Germany;Ulsan,South Korea'
    _,←';Ulyanovsk,Russia;Umlazi,South Africa;Umuarama,Brazil;Unnao,India;Uppsala,Sweden;Uralsk,Kazakstan;Urawa,Japan;Urayasu,Japan'
    _,←';Vale Royal,United Kingdom;Vale of Glamorgan,United Kingdom;Vale of White Horse,United Kingdom;Vallejo,USA;Vancouver,Canada;Vaughan,Canada'
    _,←';Venezia,Italy;Verona,Italy;Vicenza,Italy;Virginia Beach,USA;Västeras,Sweden;WASHINGTON,USA;Waco,USA;Wakefield,United Kingdom;Warren,USA'
    _,←';Waterbury,USA;West Covina,USA;Wichita,USA;Windsor,Canada;Winnipeg,Canada;Winston-Salem,USA;Worcester,USA;Xiamen,China;Xian,China'
    _,←';Xiangfan,China;Xiangta,China;Xiangtan,China;Xiannin,China;Xiantao,China;Xianyang,China;Xiaocan,China;Xichang,China;Xifeng,China'
    _,←';Xining,China;Xinji,China;Xinxiang,China;Xinyang,China;Xinyi,China;Xinyu,China;Xinzhu,China;Xuanzhou,China;Xuchang,China;Xuzhou,China'
    _,←';Yaan,China;Yachiyo,Japan;Yaizu,Japan;Yakumshi,China;Yakutsk,Russia;Yamagata,Japan;Yamaguchi,Japan;Yamato,Japan;Yonkers,USA;York,Canada'
    _,←';Zoetermeer,Netherlands;Zonguldak,Turkey;Zunyi,China;Zuozhou,China;Zwickau,Germany;s-Gravenhage,Netherlands;Çorum,Turkey;Örebro,Sweden'
    _,←';Ústí nad Labem,Czech Republic'
    (Cities Countries)←{(v p)←↓⍉(((⍴⍵)÷2),2)⍴⍵ ⋄ i←p⍳⍨pu←{⍵[⍋↑⍵]}∪p ⋄ (v,[1.1]i)pu}';,'cut _

    ⎕ex '_'

    ∇ r←{options}genNames N;opt;n1;mn;fromto;single;many;s;m;MF;i;sex
      :Access public shared
    ⍝ Generate N names, surnames and sex in a 3 column matrix of enclosures
    ⍝ A 4th column can be returned with dates
    ⍝ Options are:
    ⍝ +sex=M|F; if none names will be a mix of both
    ⍝ +middlename= if 1:x% is given x% of the names will have a middle name made out of
    ⍝       a letter followed by a dot
    ⍝ +age= if a pair of number is given the age will range from one to the other year,
    ⍝       if a  single number is given the age will range from 0 to the number given
    ⍝ +date=idn yyyy/mm/dd yyyymmdd
     
      :If 0∊⎕NC'options' ⋄ options←'' ⋄ :EndIf
      opt←(⎕NEW ⎕SE.Parser'+sex∊MF +middlename[=] +date=idn yyyy/mm/dd yyyymmdd +age=').Parse options
     
    ⍝ Generate the first names
      n1←↑,/(MF←(s≡0)⌈+/'MF'∘.=,s←opt.sex)/¨Boys Girls ⍝ set to pick from
      r←n1[i←?N⍴⍴n1] ⋄ sex←((MF×∊⍴¨Boys Girls)/'MF')[i]
      :If 0≢mn←opt.middlename ⍝ do we need a middle name?
          :If mn≡1            ⍝ yes, always
              r←r,¨' ',¨n1[?N⍴⍴n1]
          :Else ⍝ determine which portion consists of a single letter (followed by dot)
                ⍝ and which portion is whole. The rest is untouched (no middle name)
            ⍝ The specification is +middlename=[1:xx%] [ff%]  where xx represents the %
            ⍝ of single letter middlenames followed by a dot and ff represents the %
            ⍝ of full middlenames, e.g. "+middlename=30% 1:20%" means 30% of the names are
            ⍝ made up of 2 full names (name and middlename), 20% consist of names followed
            ⍝ by a single letter and a dot and the rest, 50% is made up single names.
              single←1↑↑(//)⎕VFI∊'1:(\d+)%'⎕S'\1'⊢mn
              many←1↑↑(//)⎕VFI∊'(?<!1:)(?<!\d)(\d+)%'⎕S'\1'⊢mn
              (s m)←↓1 2∘.=+/(?N⍴100)∘.>+\0,single,many
              (s/r)←(s/r),¨' ',¨⎕A[?(+/s)⍴26],¨'.'
              (m/r)←(m/r),¨' ',¨n1[?(+/m)⍴⍴n1]
          :EndIf
      :EndIf
     
    ⍝ Generate the last name and sex
      r←r,[1.1]Surnames[?N⍴⍴Surnames]
      r,←sex
     
    ⍝ Do we want a date?
      :If 0≢fromto←0 opt.Switch'age'
          r←r,opt.date genDates N,(D2I ⎕TS)-⌊365.25×¯2↑fromto
      :EndIf
    ∇

    D2I←{2 ⎕nq '.' 'DateToIDN' ⍵} ⋄ I2D←{2 ⎕nq '.' 'IDNToDate' ⍵}

    ∇ r←{options}genDates(N from to);range;min;⎕IO;fmt;idn
      :Access public shared
     ⍝ Generate N dates at random from to (IDN)
      :If 0∊⎕NC'options' ⋄ options←0 ⋄ :EndIf
      range←1+|from-to
      min←from⌊to ⍝ doesn't matter if they are reversed
      idn←r←min+?N⍴range⊣⎕IO←0
     ⍝ Any special format?
      :If options≢0 ⋄ r←⍕¨idn
      :AndIf 'yyyy'≡4⍴options
          fmt←'ZI4,',fmt,'ZI2,','ZI2',⍨fmt←{0∊⍴⍵:'' ⋄ '<',(1↑⍵),'>,'}'/-.'∩options
          r←↓fmt ⎕FMT↑3∘↑∘I2D¨idn
      :EndIf
    ∇
    
    th←{v←⍕⍵ ⋄ (4 20≠.<m1)≥1 2 3∊⍨m0←10|m1←100|⍵:v,'th' ⋄ v,'stndrd'[¯1 0+2×m0]}

    ∇ r←{options}genAddress N;nlines;names;nos;n;i;b
      :Access public shared
     ⍝ Generate N addresses of  [#|name] [str|av|blv|dr] [Suite X|app #], City, Country
      names←Boys,Girls ⋄ (N nlines)←1⌈2↑N
      nos←{0=⍵:⍬ ⋄ th¨?⍵⍴100}N-n←?N ⋄ nos,←names[?n⍴⍴names] ⋄ b←(-N)↑n⍴1 ⋄ i←N?N
      nos←(⍕¨????N⍴9999),¨', '∘,¨nos[i],¨' Str' ' Av' ' Str' ' Av' ' Str' ' Av' ' Blv' ' Dr'[?6+2×b[i]]
      r←nos←nos,¨{⍵<4:'' ⋄ ⍵=4:', Suite ',⍕?999 ⋄ ', App ',⍕?99}¨?N⍴5
      :If nlines>1 ⋄ r←nos,¨,/', '∘,¨(nlines-1)↑[2]genCity N
      :EndIf
    ∇

    ∇ r←{options}genCity N;opt;cities;i
      :Access public shared 
      :If 0=⎕NC'options' ⋄ options←'' ⋄ :EndIf
      opt←(⎕NEW ⎕SE.Parser'+country=').Parse options~0
      cities←Cities
      :If opt.country≢0
          'unknown country'⎕SIGNAL 11/⍨(1↑⍴Countries)∨.<i←Countries⍳(cut' ',opt.country)~⊂''
          cities←(cities[;2]∊i)⌿cities
      :EndIf
      r←⌽cities[?N⍴1↑⍴cities;]
      r←0 1↓r,Countries[r[;1]]
    ∇
    
    ∇ r←{options}genRecord N
      :Access public shared 
    ⍝ Generate N database records of fields, default name, surname, age, address, city, country
      :If 0=⎕NC'options' ⋄ options←'' ⋄ :EndIf
     ⍝ opt←(⎕NEW ⎕SE.Parser'+country=').Parse options~0
      r←'+middlename= 1:20% 25% +age=18 99 +date=yyyymmdd'genNames N
      r,←(genAddress N),options genCity N
    ∇

:EndNamespace  ⍝ names  $Revision: 1047 $
