﻿:Namespace CryptTools

    ∇ r←GetEnvir setting
      r←2 ⎕NQ'.' 'getenvironment'setting
    ∇

    ∇ r←DNetCrypto
     ⍝ Find the location of the cryptography libraries
     ⍝ Are we running a 32b program on a 64OS?
      :If 0∊⍴r←GetEnvir'ProgramW6432'
          r←GetEnvir'ProgramFiles'
      :EndIf
     
      r←'System.Security.Cryptography,',r,'\Reference Assemblies\Microsoft\Framework\v3.5\System.Core.dll'
    ∇

    ∇ r←SHA1hashKey(string key);⎕USING;algo;hash
     ⍝ Compute the hash string for a given string and key
      ⎕USING←'System' 'System.Security.Cryptography'
      algo←⎕NEW HMACSHA1
      algo.Key←UTF8 key
      hash←algo.ComputeHash⊂UTF8 string
      r←Convert.ToBase64String⊂hash
    ∇
     
    ∇ hash←SHA1hash string;s1;⎕USING
      ⎕USING←'System.Security.Cryptography'
      s1←⎕NEW SHA1CryptoServiceProvider
      hash←s1.ComputeHash⊂UTF8 string
    ∇

    ∇ value←hash string;str;⎕USING;sha
     ⍝ Return hash value of the string given as arg
      :If isChar str←,string
          str←⎕UCS str ⍝ turn characters into numbers for the hash fn
          {}⎕DR str    ⍝ kludge to ensure str is small int
      :EndIf
     
      ⎕USING←DNetCrypto
      sha←⎕NEW SHA256Managed ⍝ also SHA1/384/512, CRC32 & MD5CryptoServiceProvider
      value←sha.ComputeHash⊂str
    ∇

    if←/⍨
    isChar←{∨/0 2=10|⎕DR 1/⍵}

    NS←{n←⎕ns'' ⋄ n{⍺}n⍎⍺,'←⍵'}

    UTF8←'UTF-8'∘⎕ucs
    UCSN←{~isChar ⍵:⍵ ⋄ v{⍺}⎕dr v←UTF8 ⍵} ⍝ ⎕DR forces demotion

:EndNamespace ⍝ CryptTools  $Revision: 739 $ 